local assets =
{
	Asset("ANIM", "anim/nightmare_bush.zip"),
}

local prefabs = 
{
    "nightmarefuel",
    "dug_nightmare_bush",
}

local NightmaresTable =
{
"crawlinghorror",
"horridbatt",
"shadowbug",
"scaryspider",
"terrorbeak",
"wretchedrock",
"creepyman",
"wickedwarlock",
}

local function ontransplantfn(inst)
	inst.components.pickable:MakeEmpty()
end


local function dig_up(inst, chopper)
	if inst.components.pickable and inst.components.pickable:CanBePicked() then
		inst.components.lootdropper:SpawnLootPrefab("nightmarefuel")
	end
	inst:Remove()
	local bush = inst.components.lootdropper:SpawnLootPrefab("dug_nightmare_bush")
	GetPlayer().components.sanity:DoDelta(-30)
	GetPlayer().components.health:DoDelta(-5)
	SpawnPrefab("statue_transition_2").Transform:SetPosition(inst:GetPosition():Get())
	SpawnPrefab(GetRandomItem(NightmaresTable)).Transform:SetPosition(inst:GetPosition():Get())
end

local function onpickedfn(inst, picker)
	local morefuel = math.random(1,10)
	inst.AnimState:PlayAnimation("picking") 
	inst.AnimState:PushAnimation("picked", false)
	if picker.components.combat then
        picker.components.combat:GetAttacked(inst, TUNING.MARSHBUSH_DAMAGE *2)
		picker.components.sanity:DoDelta(-TUNING.SANITY_TINY)
			inst.SoundEmitter:PlaySound("dontstarve/wilson/attack_nightsword")
			SpawnPrefab("statue_transition").Transform:SetPosition(inst:GetPosition():Get())
			SpawnPrefab("statue_transition_2").Transform:SetPosition(inst:GetPosition():Get())
			if morefuel == 5 then
			SpawnPrefab("nightmarefuel").Transform:SetPosition(inst:GetPosition():Get())
			end
        picker:PushEvent("thorns")
	end
end

local function onregenfn(inst)
	inst.AnimState:PlayAnimation("grow") 
	inst.AnimState:PushAnimation("idle", true)
end

local function makeemptyfn(inst)
	inst.AnimState:PlayAnimation("idle_dead")
end

local function fn(Sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
			inst.entity:AddSoundEmitter()

    anim:SetBuild("nightmare_bush")
    anim:SetBank("marsh_bush")
    anim:PlayAnimation("idle", true)
    anim:SetTime(math.random()*2)
	inst.entity:AddMiniMapEntity()
    inst.MiniMapEntity:SetIcon("nightmarebush.tex")
	inst.MiniMapEntity:SetPriority( 5 )

    local color = 0.5 + math.random() * 0.5
    anim:SetMultColour(color, color, color, 1)

    inst:AddComponent("pickable")
    inst.components.pickable.picksound = "dontstarve/wilson/harvest_sticks"
    
    inst.components.pickable:SetUp("nightmarefuel", TUNING.FLOWER_CAVE_REGROW_TIME)
	inst.components.pickable.onregenfn = onregenfn
	inst.components.pickable.onpickedfn = onpickedfn
    inst.components.pickable.makeemptyfn = makeemptyfn
	inst.components.pickable.ontransplantfn = ontransplantfn

    --inst:AddComponent("sanityaura")
    --inst.components.sanityaura.aurafn = 1
	
	inst:AddComponent("lootdropper")
	inst:AddComponent("workable")
    inst.components.workable:SetWorkAction(ACTIONS.DIG)
    inst.components.workable:SetOnFinishCallback(dig_up)
    inst.components.workable:SetWorkLeft(1)
    
    inst:AddComponent("inspectable")
	inst:AddTag("thorny")
    
    MakeLargeBurnable(inst)
    MakeLargePropagator(inst)

    return inst
end

return Prefab( "marsh/objects/nightmare_bush", fn, assets, prefabs) 
